#include "PauseState.h"
#include "StateManager.h"
#include "PlayState.h"
#include "Help.h"
#include "Option.h"

PauseState::PauseState()
{

}

PauseState::PauseState(IDStateGame id)
{
	m_ID = id;
}

PauseState::~PauseState()
{
	delete m_Arrow;
}

void PauseState::Init()
{
	m_ID = MENU;

	m_Arrow = new Arrow(10, 10, 10, 14, 2);
}

void PauseState::Update()
{
	//Selection
	m_Arrow->Update();

	if (GIsKeyPress(KEY_ENTER))
	{
		StateManager::getInstance()->removeStateGame();
		switch (m_Arrow->m_Position.y)
		{
		case 10:
		{
				   StateManager::getInstance()->Resume();
				   break;
		}

		case 12:
		{
				   StateManager::getInstance()->addStateGame(new MenuState(IDStateGame::MENU));
				   break;
		}
		case 14:
			exit(1);
			break;
		default:
			break;
		}
	}

	if (GIsKeyPress(KEY_ESC))
	{
		StateManager::getInstance()->removeStateGame();
		StateManager::getInstance()->Resume();
	}
}

void PauseState::Draw()
{
	m_Arrow->Draw();
	GPutStringToBuffer("PAUSE", 15, 6);
	GPutStringToBuffer("Resume", 15, 10);
	GPutStringToBuffer("Main Menu", 15, 12);
	GPutStringToBuffer("Exit", 15, 14);
}